/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.play;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.blockentity.RecycleBinBlockEntity;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.PostBoxMenu;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.item.PackageItem;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageClearMessage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerOpenProgram;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import com.mrcrayfish.furniture.refurbished.network.message.MessageHomeControl;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSendPackage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSetName;
import com.mrcrayfish.furniture.refurbished.network.message.MessageShowDeliveryResult;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdatePainting;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWithdrawExperience;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ServerPlayHandler {
    public static void handleMessageSetName(MessageSetName message, @Nullable ServerPlayer player) {
        BlockEntity blockEntity;
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        if (level.m_46749_(message.getPos()) && (blockEntity = level.m_7702_(message.getPos())) instanceof INameable) {
            INameable nameable = (INameable)blockEntity;
            nameable.setName(player, message.getName().trim());
        }
    }

    public static void handleMessageSendPackage(MessageSendPackage message, @Nullable ServerPlayer player, MessageContext context) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof PostBoxMenu) {
            PostBoxMenu menu = (PostBoxMenu)abstractContainerMenu;
            Container container = menu.getContainer();
            if (container.m_7983_()) {
                return;
            }
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || !DeliveryService.isBannedItem(stack)) continue;
                return;
            }
            DeliveryService.get(player.f_8924_).ifPresent(service -> {
                ItemStack stack = PackageItem.create(container, message.getMessage(), player.m_36316_().getName());
                DeliveryResult result = service.sendMail(message.getMailboxId(), stack);
                if (result.success()) {
                    container.m_6211_();
                    Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageClearMessage());
                    Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageShowDeliveryResult(result));
                } else {
                    result.message().ifPresent(s -> Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageShowDeliveryResult(result)));
                }
            });
        }
    }

    public static void handleMessageDeleteLink(MessageDeleteLink message, @Nullable ServerPlayer player) {
        Connection c;
        Level level;
        if (player != null && player.m_21205_().m_150930_((Item)ModItems.WRENCH.get()) && (level = player.m_9236_()).m_46749_((c = Connection.of(message.getPosA(), message.getPosB())).getPosA()) && level.m_46749_(c.getPosB())) {
            Vec3 a = c.getPosA().m_252807_();
            Vec3 b = c.getPosB().m_252807_();
            double maxDistance = Math.max(25.0, a.m_82557_(b));
            if (player.m_20238_(a) > maxDistance && player.m_20238_(b) > maxDistance) {
                return;
            }
            IElectricityNode nodeA = c.getNodeA(level);
            IElectricityNode nodeB = c.getNodeB(level);
            if (nodeA != null && nodeB != null && nodeA.isConnectedToNode(nodeB)) {
                nodeA.removeNodeConnection(c);
                nodeB.removeNodeConnection(c);
            } else if (nodeA != null && nodeB == null) {
                nodeA.removeNodeConnection(c);
            } else if (nodeA == null && nodeB != null) {
                nodeB.removeNodeConnection(c);
            }
        }
    }

    public static void handleMessageToggleSwitch(MessageTogglePower message, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof IPowerSwitchMenu) {
            IPowerSwitchMenu menu = (IPowerSwitchMenu)abstractContainerMenu;
            menu.toggle();
        }
    }

    public static void handleMessageTennisGame(MessagePaddleBall.Action message, ServerPlayer player) {
        ComputerMenu menu;
        Program program;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof ComputerMenu && (program = (menu = (ComputerMenu)abstractContainerMenu).getComputer().getProgram()) instanceof PaddleBall) {
            PaddleBall game = (PaddleBall)program;
            game.update(message.getMode(), message.getData());
        }
    }

    public static void handleMessageComputerOpenProgram(MessageComputerOpenProgram message, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)abstractContainerMenu;
            menu.getComputer().launchProgram(message.getId());
        }
    }

    public static void handleMessageUpdatePainting(MessageUpdatePainting message, ServerPlayer player) {
        DoorMatMenu menu;
        IPaintable paintable;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof DoorMatMenu && (paintable = (menu = (DoorMatMenu)abstractContainerMenu).getPaintable()).isEditable()) {
            paintable.setImage(message.getImage());
            paintable.setEditable(false);
            player.m_6915_();
        }
    }

    public static void handleMessageHomeControlToggle(MessageHomeControl.Toggle message, ServerPlayer player) {
        ComputerMenu menu;
        Program program;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof ComputerMenu && (program = (menu = (ComputerMenu)abstractContainerMenu).getComputer().getProgram()) instanceof HomeControl) {
            HomeControl program2 = (HomeControl)program;
            program2.toggleDevice(message.getPos());
        }
    }

    public static void handleMessageHomeControlUpdateAll(MessageHomeControl.UpdateAll message, ServerPlayer player) {
        ComputerMenu menu;
        Program program;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof ComputerMenu && (program = (menu = (ComputerMenu)abstractContainerMenu).getComputer().getProgram()) instanceof HomeControl) {
            HomeControl program2 = (HomeControl)program;
            program2.updateDevices(message.getState());
        }
    }

    public static void handleMessageWorkbenchSelectRecipe(MessageWorkbench.SelectRecipe message, ServerPlayer player) {
        if (player != null) {
            WorkbenchMenu menu;
            player.m_9243_();
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof WorkbenchMenu && (menu = (WorkbenchMenu)abstractContainerMenu).m_6875_((Player)player) && !player.m_5833_() && menu.m_6366_((Player)player, message.getIndex())) {
                menu.m_38946_();
            }
        }
    }

    public static void handleMessageWorkbenchSearchNeighbours(MessageWorkbench.SearchNeighbours message, ServerPlayer player) {
        if (player != null) {
            WorkbenchMenu menu;
            player.m_9243_();
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof WorkbenchMenu && (menu = (WorkbenchMenu)abstractContainerMenu).m_6875_((Player)player) && !player.m_5833_()) {
                menu.toggleSearchNeighbours();
            }
        }
    }

    public static void handleMessageWithdrawExperience(MessageWithdrawExperience message, ServerPlayer player) {
        if (player != null) {
            Container container;
            RecycleBinMenu menu;
            player.m_9243_();
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof RecycleBinMenu && (menu = (RecycleBinMenu)abstractContainerMenu).m_6875_((Player)player) && !player.m_5833_() && (container = menu.getContainer()) instanceof RecycleBinBlockEntity) {
                RecycleBinBlockEntity entity = (RecycleBinBlockEntity)container;
                entity.withdrawExperience(player);
            }
        }
    }
}

